#ifndef NASCCL_SwapMatrix_Cpp
#define NASCCL_SwapMatrix_Cpp
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
    These functions are used to swap the values from one "matrix set" (Matrix[x][y])
    to another. This keeps the algorithm from continuously calculating the matrix
    values with the same values... Round After Round.

    These functions are called only from the Encode / Decode functions
    and only when the "Swap Matrix" flag is set.

    An excellent encryption perk. Very fast...
*/
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "NASCCL.H"
#include "sBoxes.H"
#include "Math.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void NASCCL::SwapMatrix(int inSwap, int inWith)
{
    SwapBytes( Matrix[0][inSwap], Matrix[5][inWith] );
    SwapBytes( Matrix[1][inSwap], Matrix[4][inWith] );
    SwapBytes( Matrix[2][inSwap], Matrix[3][inWith] );
    SwapBytes( Matrix[3][inSwap], Matrix[2][inWith] );
    SwapBytes( Matrix[4][inSwap], Matrix[1][inWith] );
    SwapBytes( Matrix[5][inSwap], Matrix[0][inWith] );
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

